package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ProfileSelectionProcessor implements SelectionProcessor<Object, ReadGraph> {

    @Override
    public Collection<?> process(Object selection, ReadGraph g) {
        try {
            Resource object = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, Resource.class);
            ProfileTuple object2 = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, ProfileTuple.class);

            return processInternal(g, object, object2, selection);
            	
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }

        return Collections.emptyList();
    }

    private Collection<?> processInternal(ReadGraph g, Resource object, ProfileTuple pair, Object selection) throws DatabaseException {

    	Collection<Object> inputs = new ArrayList<Object>();
    	
    	parseResourceInput(g, object, pair, inputs);

        return accept(inputs);
    }

    Collection<ComparableTabContributor> accept(Collection<?> inputs) {
        Set<ComparableTabContributor> result = new TreeSet<ComparableTabContributor>();
//        System.out.println("accept:");
        for (Object input : inputs) {
//            System.out.println("\tINPUT: " + input);
        	if (input instanceof SCLInput) {
            	SCLInput configurationInput = (SCLInput)input;
                result.add(new ComparableTabContributor(new SCLEditorComposite(), configurationInput.priority, configurationInput.getDatum(), configurationInput.text));
//                result.add(new ComparableTabContributor(new ResourceDescriptionSourceComposite(), -4, configurationInput.getDatum(), "Source"));
            }
        }
        return result;
    }

    private void parseResourceInput(ReadGraph g, Resource part, ProfileTuple pair, Collection<Object> inputs) throws DatabaseException {
        getGroups(g, part, pair, inputs);
    }

    void getGroups(ReadGraph g, Resource r, ProfileTuple p, Collection<Object> result) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance(g);
        if (r != null && g.isInstanceOf(r, dr.SCLGroup)) {
            result.add(new SCLInput(r, 1, "SCL Group"));
        }
        if (r != null && g.isInstanceOf(r, dr.SCLTextStyle)) {
            result.add(new SCLInput(r, 2, "SCL Text Style"));
        }
        if (p != null && g.isInstanceOf(p.getEntry(), dr.GroupStyleProfileEntry)) {
        	Resource group = g.getPossibleObject(p.getEntry(), dr.ProfileEntry_HasGroup);
       		if (group != null && g.isInstanceOf(group, dr.SCLGroup)) {
                result.add(new SCLInput(group, 1, "SCL Group"));
            }
        	Resource style = g.getPossibleObject(p.getEntry(), dr.ProfileEntry_HasStyle);
       		if (style != null && g.isInstanceOf(style, dr.SCLTextStyle)) {
                result.add(new SCLInput(style, 2, "SCL Text Style"));
            }
        }
    }

}