/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.tests.actions;

import java.awt.Graphics2D;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.PlainExampleLineEndStyle;

public class NewTerminalAction implements IAction {

    RouteGraph rg;    
    double connectionStartX;
    double connectionStartY;
    
    public NewTerminalAction(RouteGraph rg, double connectionStartX,
            double connectionStartY) {
        this.rg = rg;
        this.connectionStartX = connectionStartX;
        this.connectionStartY = connectionStartY;
    }
    
    private static RouteTerminal addTerminal(RouteGraph rg, double x, double y) {
        return rg.addTerminal(x, y, x-20, y-20, x+20, y+20, 1, PlainExampleLineEndStyle.INSTANCE);
    }
    
    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        RouteGraph rgc = rg.copy();
        RouteTerminal t1 = addTerminal(rgc, connectionStartX, connectionStartY);
        if(rgc.connectTerminal(t1, mouseX, mouseY, TOLERANCE)) {
            renderer.render(g, rgc);
        }            
        else {            
            rgc = new RouteGraph();
            t1 = addTerminal(rgc, connectionStartX, connectionStartY);
            RouteTerminal t2 = rgc.addTerminal(mouseX, mouseY, 
                    mouseX, mouseY,
                    mouseX, mouseY, 15);
            rgc.link(t1, t2);
            renderer.render(g, rgc);
            
            renderer.render(g, rg);
        }
    }

    public void finish(double x, double y) {
        RouteTerminal t1 = addTerminal(rg, connectionStartX, connectionStartY);
        rg.connectTerminal(t1, x, y, TOLERANCE);
    }

}
