/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

public class Directions {

    public static boolean isAllowed(int allowedDirection, int direction) {
        return ((allowedDirection >> direction)&1) == 1;
    }

    public static int firstAllowedDirection(int allowedDirections) {
        for(int dir=0;dir<4;++dir,allowedDirections>>=1) {
            if((allowedDirections&1) == 1)
                return dir;
        }
        return 0;
    }
    
}
