/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.desktop.ui.internal;

import org.simantics.project.ProjectKeys;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;

public class DesktopProjectFeature extends AbstractProjectFeature {

    private static final String DEFAULT_PERSPECTIVE = "org.simantics.desktop.modelling.perspective"; //$NON-NLS-1$

    @Override
    public void configure() throws ProjectException {
    	
    	Object existing = getProjectElement().getHint(ProjectKeys.DEFAULT_PERSPECTIVE);
    	if(existing == null)
    		getProjectElement().setHint(ProjectKeys.DEFAULT_PERSPECTIVE, DEFAULT_PERSPECTIVE);

    }

    @Override
    public void deconfigure() throws ProjectException {
    	
    }

}
