/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.debug.ui.Messages;
import org.simantics.debug.ui.VariableDebugger;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableDebuggerView
extends ViewPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableDebuggerView.class);
    public static final String VIEW_ID = "org.simantics.debug.variableDebugger";
    private ResourceInput input;
    private Session session;
    private VariableDebugger debugger;
    private Action parentAction;
    private Action backAction;
    private Action forwardAction;
    private Action refreshAction;
    private Action homeAction;

    public void createPartControl(Composite parent) {
        this.session = Simantics.getSession();
        String sid = this.getViewSite().getSecondaryId();
        Resource r = null;
        if (sid != null) {
            this.input = ResourceInput.unmarshall((String)sid);
            try {
                r = this.input.toResource(this.session);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        String initialURI = null;
        try {
            if (r != null) {
                initialURI = (String)this.session.sync((ReadInterface)new ResourceToPossibleURI(r));
            }
        }
        catch (Throwable throwable) {}
        this.debugger = new VariableDebugger(parent, 0, this.session, initialURI);
        this.debugger.defaultInitializeUI();
        this.makeActions();
        this.contributeActions(this.getViewSite().getActionBars());
        this.updateActionStates();
    }

    public void dispose() {
        super.dispose();
    }

    private void makeActions() {
        this.parentAction = new ParentAction();
        this.backAction = new BackAction();
        this.forwardAction = new ForwardAction();
        this.refreshAction = new RefreshAction();
        this.homeAction = new HomeAction();
    }

    private void contributeActions(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.parentAction);
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.refreshAction);
        toolBar.add((IAction)this.homeAction);
    }

    public void setFocus() {
        if (this.debugger != null) {
            this.debugger.setFocus();
        }
    }

    private void refreshBrowser() {
        this.debugger.refreshBrowser();
    }

    private void parent() {
        this.debugger.parent();
    }

    private void back() {
        this.debugger.back();
    }

    private void forward() {
        this.debugger.forward();
    }

    private void navigateHome() {
        Resource rootLibrary = this.session.getRootLibrary();
        try {
            this.debugger.changeLocation((String)this.session.sync((ReadInterface)new ResourceToURI(rootLibrary)));
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to navigate home", (Throwable)e);
        }
    }

    private void updateActionStates() {
        this.backAction.setEnabled(this.debugger.hasBackHistory());
        this.forwardAction.setEnabled(this.debugger.hasForwardHistory());
    }

    class BackAction
    extends Action {
        public BackAction() {
            super(Messages.VariableDebuggerView_Back, 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            VariableDebuggerView.this.back();
        }
    }

    class ForwardAction
    extends Action {
        public ForwardAction() {
            super(Messages.VariableDebuggerView_Forward, 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            VariableDebuggerView.this.forward();
        }
    }

    class HomeAction
    extends Action {
        public HomeAction() {
            super(Messages.VariableDebuggerView_Home, 1);
            this.setToolTipText(Messages.VariableDebuggerView_HomeTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV_DISABLED"));
        }

        public void run() {
            VariableDebuggerView.this.navigateHome();
        }
    }

    class ParentAction
    extends Action {
        public ParentAction() {
            super(Messages.VariableDebuggerView_Parent, 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UP"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UP_DISABLED"));
        }

        public void run() {
            VariableDebuggerView.this.parent();
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            super(Messages.VariableDebuggerView_Refresh, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"icons/refresh.gif"));
        }

        public void run() {
            VariableDebuggerView.this.refreshBrowser();
        }
    }
}

