/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NumericNode;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.simantics.Simantics;
import org.simantics.db.ChangeSet;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.debug.graphical.LabelingPreferences;
import org.simantics.debug.graphical.UsefulKeyAdapter;
import org.simantics.debug.graphical.layout.ExtensionLayoutAlgorithm;
import org.simantics.debug.graphical.layout.LayoutGraph;
import org.simantics.debug.graphical.model.Edge;
import org.simantics.debug.graphical.model.LabelContent;
import org.simantics.debug.graphical.model.Node;
import org.simantics.debug.graphical.model.NodeData;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerCanvas
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerCanvas.class);
    private static final long serialVersionUID = -718678297301786379L;
    ArrayList<Node> nodes = new ArrayList();
    THashMap<Resource, Node> nodeMap = new THashMap();
    ArrayList<Edge> edges = new ArrayList();
    ArrayList<Node> extensionNodes = new ArrayList();
    ArrayList<Edge> extensionEdges = new ArrayList();
    ArrayList<Edge> addedEdges = new ArrayList();
    ArrayList<Edge> removedEdges = new ArrayList();
    double canvasPosX = 0.0;
    double canvasPosY = 0.0;
    double canvasZoom = 1.0;
    boolean extensionMode = false;
    Random random = new Random();
    public Function statementFilter;
    LabelingPreferences labelingPreferences = new LabelingPreferences();
    Node dragging;
    double dragDX;
    double dragDY;
    Point2D panningStartMouse;
    THashMap<Resource, Node> extensionNodeMap;

    public DebuggerCanvas() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                double x = DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom;
                double y = DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom;
                if (e.getButton() == 1) {
                    DebuggerCanvas.this.handleMouseLeftPressed(x, y);
                } else if (e.getButton() == 2) {
                    DebuggerCanvas.this.handleMouseMiddlePressed(x, y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DebuggerCanvas.this.handleMouseMoved(DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom, DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DebuggerCanvas.this.handleMouseReleased(DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom, DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double x = DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom;
                double y = DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom;
                DebuggerCanvas.this.handleMouseWheelMoved(x, y, e.getWheelRotation());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DebuggerCanvas.this.handleMouseMoved(DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom, DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double x = DebuggerCanvas.this.canvasPosX + (double)e.getX() / DebuggerCanvas.this.canvasZoom;
                double y = DebuggerCanvas.this.canvasPosY + (double)e.getY() / DebuggerCanvas.this.canvasZoom;
                DebuggerCanvas.this.handleMouseWheelMoved(x, y, e.getWheelRotation());
            }
        });
        this.addKeyListener(new UsefulKeyAdapter(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DebuggerCanvas.this.keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DebuggerCanvas.this.keyReleased(e);
            }
        }));
        new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                block14: {
                    try {
                        Transferable transferable = dtde.getTransferable();
                        if (transferable.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
                            dtde.acceptDrop(2);
                            transferable.getTransferData(LocalObjectTransferable.FLAVOR);
                            Object obj = LocalObjectTransfer.getTransfer().getObject();
                            DebuggerCanvas.this.handleDrop(dtde, obj);
                            break block14;
                        }
                        DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors());
                        if (textFlavor != null) {
                            Throwable throwable = null;
                            Object var5_8 = null;
                            try (Reader reader = textFlavor.getReaderForText(transferable);){
                                ObjectMapper mapper = new ObjectMapper();
                                JsonNode node = mapper.readTree(reader);
                                final JsonNode resourceId = node.get("resourceId");
                                if (resourceId instanceof NumericNode) {
                                    dtde.acceptDrop(2);
                                    transferable.getTransferData(LocalObjectTransferable.FLAVOR);
                                    StructuredSelection obj = new StructuredSelection(Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                                        public Resource perform(ReadGraph graph) throws DatabaseException {
                                            SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                                            return ss.getResource(((NumericNode)resourceId).longValue());
                                        }
                                    }));
                                    DebuggerCanvas.this.handleDrop(dtde, obj);
                                    return;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        dtde.rejectDrop();
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Drop failed.", (Throwable)exception);
                        dtde.rejectDrop();
                    }
                }
            }
        });
        this.dragging = null;
        this.extensionNodeMap = new THashMap();
    }

    public void setStatementFilter(Function statementFilter) {
        this.statementFilter = statementFilter;
    }

    public void removeStatementFilter() {
        this.statementFilter = null;
    }

    @Override
    public void paint(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(200, 200, 200), this.getWidth(), this.getHeight(), Color.WHITE));
        g.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        g.setColor(Color.BLACK);
        g.setTransform(new AffineTransform(this.canvasZoom, 0.0, 0.0, this.canvasZoom, -this.canvasPosX * this.canvasZoom, -this.canvasPosY * this.canvasZoom));
        for (Node node : this.nodes) {
            node.render(g);
        }
        for (Edge edge : this.edges) {
            edge.render(g);
        }
        if (this.extensionMode) {
            for (Node node : this.extensionNodes) {
                node.render(g);
            }
            for (Edge edge : this.extensionEdges) {
                edge.render(g);
            }
        }
        g.setColor(Color.GREEN);
        for (Edge edge : this.addedEdges) {
            edge.render(g);
        }
        g.setColor(Color.RED);
        for (Edge edge : this.removedEdges) {
            edge.render(g);
        }
    }

    public Node pick(double x, double y) {
        for (Node node : this.nodes) {
            if (!node.pick(x, y)) continue;
            return node;
        }
        return null;
    }

    public Node pickExtension(double x, double y) {
        for (Node node : this.extensionNodes) {
            if (!node.pick(x, y)) continue;
            return node;
        }
        return null;
    }

    private void handleDrop(DropTargetDropEvent dtde, Object obj) {
        double x = this.canvasPosX + dtde.getLocation().getX() / this.canvasZoom;
        double y = this.canvasPosY + dtde.getLocation().getY() / this.canvasZoom;
        this.handleDrop(x, y, obj);
        dtde.getDropTargetContext().dropComplete(true);
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 49: {
                this.zoomToFit();
                break;
            }
            case 76: {
                this.layoutGraph();
                break;
            }
            case 17: {
                if (this.extensionMode) break;
                this.initializeExtension();
                this.extensionMode = true;
                this.repaint();
                break;
            }
            case 67: {
                this.findPreviousChangeset();
                break;
            }
            case 127: {
                if (this.extensionMode || this.dragging == null) break;
                this.nodes.remove(this.dragging);
                this.scheduleUpdate();
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.extensionMode = false;
            this.scheduleUpdate();
            this.repaint();
        }
    }

    private static Resource extractResource(Object obj) {
        Resource resource;
        System.out.println("- " + obj.getClass().getName());
        if (obj instanceof WorkbenchSelectionElement && (resource = (Resource)((WorkbenchSelectionElement)obj).getContent((WorkbenchSelectionContentType)new AnyResource((RequestProcessor)Simantics.getSession()))) != null) {
            return resource;
        }
        if (obj instanceof IAdaptable && (resource = (Resource)((IAdaptable)obj).getAdapter(Resource.class)) != null) {
            return resource;
        }
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        return null;
    }

    private void handleDrop(double x, double y, Object obj) {
        if (obj instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)obj).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Resource resource = DebuggerCanvas.extractResource(element);
                if (resource != null && !this.nodeMap.containsKey((Object)resource)) {
                    this.addResource(x, y, resource);
                    this.repaint();
                }
                ++n2;
            }
        }
    }

    private Node addResource(double x, double y, Resource resource) {
        Node a = new Node(new NodeData(resource));
        a.setPos(x, y);
        this.scheduleUpdate();
        this.nodes.add(a);
        return a;
    }

    public void addResource(Resource resource) {
        double y;
        double x;
        if (this.nodes.isEmpty()) {
            x = 0.0;
            y = 0.0;
        } else {
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Node node : this.nodes) {
                xMin = Math.min(node.getMinX(), xMin);
                yMin = Math.min(node.getMinY(), yMin);
                xMax = Math.max(node.getMaxX(), xMax);
                yMax = Math.max(node.getMaxY(), yMax);
            }
            x = xMin + (xMax - xMin) * this.random.nextDouble();
            y = yMin + (yMax - yMin) * this.random.nextDouble();
        }
        this.addResource(x, y, resource);
        this.repaint();
    }

    private void scheduleUpdate() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DebuggerCanvas.this.updateNodes(graph);
                DebuggerCanvas.this.updateEdges(graph);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebuggerCanvas.this.repaint();
                    }
                });
            }
        });
    }

    public void layoutGraph() {
        ArrayList<Edge> allEdges = new ArrayList<Edge>(this.edges.size() + this.addedEdges.size() + this.removedEdges.size());
        allEdges.addAll(this.edges);
        allEdges.addAll(this.addedEdges);
        allEdges.addAll(this.removedEdges);
        LayoutGraph.layout(this.nodes.toArray(new Node[this.nodes.size()]), allEdges.toArray(new Edge[this.edges.size()]));
        this.repaint();
    }

    private void updateNodes(ReadGraph graph) throws DatabaseException {
        for (Node node : this.nodes) {
            node.getData().updateData(graph, this.labelingPreferences);
            node.setContent(new LabelContent(node.getData().getLabels()));
        }
        this.nodeMap.clear();
        for (Node node : this.nodes) {
            NodeData data = node.getData();
            this.nodeMap.put((Object)data.getResource(), (Object)node);
        }
    }

    private void updateEdges(ReadGraph graph) throws DatabaseException {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node node : this.nodes) {
            NodeData data = node.getData();
            Resource subject = data.getResource();
            ArrayList<Statement> filteredStatements = new ArrayList<Statement>(data.getStatements().size());
            for (Statement stat : data.getStatements()) {
                Resource object = stat.getObject();
                Node node2 = (Node)this.nodeMap.get((Object)object);
                if (node2 != null) {
                    if (object.getResourceId() <= subject.getResourceId() && graph.getPossibleInverse(stat.getPredicate()) != null) continue;
                    edges.add(this.createEdge(graph, stat, node, node2));
                    continue;
                }
                filteredStatements.add(stat);
            }
            data.setStatements(filteredStatements);
        }
        this.edges = edges;
        this.addedEdges = this.filterEdgesWithoutNodes(this.addedEdges);
        this.removedEdges = this.filterEdgesWithoutNodes(this.removedEdges);
    }

    private ArrayList<Edge> filterEdgesWithoutNodes(Collection<Edge> edges) {
        ArrayList<Edge> result = new ArrayList<Edge>(edges.size());
        for (Edge e : edges) {
            if (!this.nodeMap.containsValue((Object)e.getA()) || !this.nodeMap.containsValue((Object)e.getB())) continue;
            result.add(e);
        }
        return result;
    }

    private Edge createEdge(ReadGraph graph, Statement stat, Node n1, Node n2) throws DatabaseException {
        Resource predicate = stat.getPredicate();
        Resource inverse = graph.getPossibleInverse(predicate);
        if (inverse != null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (graph.hasStatement(predicate, L0.PartOf, inverse) || predicate.equals(L0.PartOf) || predicate.equals(L0.SuperrelationOf) || predicate.equals(L0.SupertypeOf)) {
                predicate = inverse;
                Node temp = n1;
                n1 = n2;
                n2 = temp;
            }
        }
        Edge edge = new Edge(n1, n2);
        edge.setContent(new LabelContent(new String[]{NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate)}));
        return edge;
    }

    private void handleMouseLeftPressed(double x, double y) {
        Node node;
        if (this.extensionMode) {
            node = this.pickExtension(x, y);
            if (node != null) {
                this.nodes.add(node);
                this.extensionNodes.remove(node);
            }
        } else {
            node = this.pick(x, y);
        }
        if (node != null) {
            this.dragDX = x - node.getX();
            this.dragDY = y - node.getY();
            this.dragging = node;
        }
    }

    private void handleMouseMiddlePressed(double x, double y) {
        this.panningStartMouse = new Point2D.Double(x, y);
    }

    private void handleMouseMoved(double x, double y) {
        if (this.dragging != null) {
            this.dragging.setPos(x - this.dragDX, y - this.dragDY);
            this.repaint();
        }
        if (this.panningStartMouse != null) {
            this.canvasPosX -= x - this.panningStartMouse.getX();
            this.canvasPosY -= y - this.panningStartMouse.getY();
            this.repaint();
        }
    }

    private void handleMouseWheelMoved(double x, double y, double amount) {
        double s = Math.exp(-0.2 * amount);
        this.canvasZoom *= s;
        this.canvasPosX = x - (x - this.canvasPosX) / s;
        this.canvasPosY = y - (y - this.canvasPosY) / s;
        this.repaint();
    }

    private void handleMouseReleased(double x, double y) {
        this.dragging = null;
        this.panningStartMouse = null;
    }

    public void zoomToFit() {
        if (!this.nodes.isEmpty()) {
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            System.out.println("(" + minX + "," + minY + ") - (" + maxX + "," + maxY + ")");
            for (Node node : this.nodes) {
                minX = Math.min(minX, node.getMinX());
                minY = Math.min(minY, node.getMinY());
                maxX = Math.max(maxX, node.getMaxX());
                maxY = Math.max(maxY, node.getMaxY());
            }
            this.canvasZoom = Math.min((double)this.getWidth() / (maxX - minX), (double)this.getHeight() / (maxY - minY));
            this.canvasZoom *= 0.9;
            this.canvasPosX = minX - 0.5 * ((double)this.getWidth() / this.canvasZoom - maxX + minX);
            this.canvasPosY = minY - 0.5 * ((double)this.getHeight() / this.canvasZoom - maxY + minY);
            this.repaint();
        }
    }

    public void initializeExtension() {
        this.extensionNodes.clear();
        this.extensionEdges.clear();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SCLContext sclContext = SCLContext.getCurrent();
                    Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                    try {
                        try {
                            THashMap<Resource, Node> oldExtensionNodeMap = DebuggerCanvas.this.extensionNodeMap;
                            THashMap extensionNodeMap = new THashMap();
                            for (Node node : DebuggerCanvas.this.nodes) {
                                for (Statement stat : node.getData().getStatements()) {
                                    Resource object = stat.getObject();
                                    Node node2 = (Node)extensionNodeMap.get((Object)object);
                                    if (node2 == null) {
                                        if (DebuggerCanvas.this.statementFilter != null && Boolean.FALSE.equals(DebuggerCanvas.this.statementFilter.apply((Object)stat))) continue;
                                        node2 = (Node)oldExtensionNodeMap.get((Object)object);
                                        if (node2 == null) {
                                            node2 = new Node(new NodeData(object));
                                            double angle = DebuggerCanvas.this.random.nextDouble() * Math.PI * 2.0;
                                            double dx = Math.cos(angle);
                                            double dy = Math.sin(angle);
                                            double len = 150.0;
                                            node2.setPos(node.getX() + dx * len, node.getY() + dy * len);
                                        }
                                        node2.getData().updateData(graph, DebuggerCanvas.this.labelingPreferences);
                                        node2.setContent(new LabelContent(node2.getData().getLabels()));
                                        extensionNodeMap.put((Object)object, (Object)node2);
                                        DebuggerCanvas.this.extensionNodes.add(node2);
                                    }
                                    DebuggerCanvas.this.extensionEdges.add(DebuggerCanvas.this.createEdge(graph, stat, node, node2));
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (t instanceof DatabaseException) {
                                throw (DatabaseException)t;
                            }
                            throw new DatabaseException(t);
                        }
                    }
                    finally {
                        sclContext.put((Object)"graph", oldGraph);
                    }
                    DebuggerCanvas.this.extensionNodeMap = DebuggerCanvas.this.extensionNodeMap;
                    DebuggerCanvas.this.layoutExtension();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void layoutExtension() {
        TObjectIntHashMap extensionNodeIds = new TObjectIntHashMap();
        int i = 0;
        while (i < this.extensionNodes.size()) {
            extensionNodeIds.put((Object)this.extensionNodes.get(i), i);
            ++i;
        }
        double[][] neighbors = new double[this.extensionNodes.size()][];
        TDoubleArrayList[] neighborLists = new TDoubleArrayList[neighbors.length];
        int i2 = 0;
        while (i2 < neighborLists.length) {
            neighborLists[i2] = new TDoubleArrayList();
            ++i2;
        }
        for (Edge edge : this.extensionEdges) {
            Node node;
            int id;
            if (extensionNodeIds.containsKey((Object)edge.getA())) {
                id = extensionNodeIds.get((Object)edge.getA());
                node = edge.getB();
            } else {
                id = extensionNodeIds.get((Object)edge.getB());
                node = edge.getA();
            }
            TDoubleArrayList list = neighborLists[id];
            list.add(node.getX());
            list.add(node.getY());
        }
        i = 0;
        while (i < neighborLists.length) {
            neighbors[i] = neighborLists[i].toArray();
            ++i;
        }
        double[] fixedRepulsiveX = new double[this.nodes.size()];
        double[] fixedRepulsiveY = new double[this.nodes.size()];
        int i3 = 0;
        while (i3 < this.nodes.size()) {
            Node node = this.nodes.get(i3);
            fixedRepulsiveX[i3] = node.getX();
            fixedRepulsiveY[i3] = node.getY();
            ++i3;
        }
        ExtensionLayoutAlgorithm algo = new ExtensionLayoutAlgorithm(neighbors, fixedRepulsiveX, fixedRepulsiveY);
        double[] posX = algo.getPosX();
        double[] posY = algo.getPosY();
        int i4 = 0;
        while (i4 < this.extensionNodes.size()) {
            posX[i4] = this.extensionNodes.get(i4).getX();
            posY[i4] = this.extensionNodes.get(i4).getY();
            ++i4;
        }
        algo.optimize();
        i4 = 0;
        while (i4 < this.extensionNodes.size()) {
            this.extensionNodes.get(i4).setPos(posX[i4], posY[i4]);
            ++i4;
        }
    }

    private Node getNode(Resource resource) {
        Node node = (Node)this.nodeMap.get((Object)resource);
        if (node == null) {
            node = this.addResource(this.random.nextDouble() * 200.0 - 100.0, this.random.nextDouble() * 200.0 - 100.0, resource);
            this.nodeMap.put((Object)resource, (Object)node);
        }
        return node;
    }

    public void findPreviousChangeset() {
        try {
            Session session = Simantics.getSession();
            final ManagementSupport ms = (ManagementSupport)session.getService(ManagementSupport.class);
            final long lastId = ms.getHeadRevisionId();
            final long firstId = DebuggerCanvas.getOpId(ms, lastId);
            this.addedEdges.clear();
            this.removedEdges.clear();
            session.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Collection css = ms.fetchChangeSets(graph, firstId, lastId);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (ChangeSet cs : css) {
                        for (ChangeSet.StatementChange stat : cs.changedStatements()) {
                            Resource predicate = stat.getPredicate();
                            if (predicate.equals(L0.InstanceOf) || predicate.equals(L0.HasName) || predicate.equals(L0.NameOf)) continue;
                            Edge edge = DebuggerCanvas.this.createEdge(graph, (Statement)stat, DebuggerCanvas.this.getNode(stat.getSubject()), DebuggerCanvas.this.getNode(stat.getObject()));
                            if (stat.isClaim()) {
                                DebuggerCanvas.this.addedEdges.add(edge);
                                continue;
                            }
                            DebuggerCanvas.this.removedEdges.add(edge);
                        }
                    }
                    DebuggerCanvas.this.scheduleUpdate();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private static long getOpId(ManagementSupport ms, long revisionId) throws DatabaseException {
        Collection ids = ms.getChangeSetIdentifiers(revisionId, revisionId);
        ChangeSetIdentifier curId = (ChangeSetIdentifier)ids.iterator().next();
        byte[] opIdData = (byte[])curId.getMetadata().get("opid");
        System.out.println(new String(opIdData));
        long opId = Long.parseLong(new String(opIdData));
        if (opId == 0L) {
            opId = revisionId;
        }
        return opId;
    }
}

