/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.impl;

import org.eclipse.core.runtime.Platform;

public class Configuration {
    public final boolean purge = false;
    public final boolean debug = false;
    public final boolean remoteCore = false;
    public final boolean useJournal = false;
    public final boolean useFailedTests;
    public final boolean virtual;
    public final boolean transactionKeep;
    public final String workspace = "../../";
    public final String coreDir = Platform.getLocation().append("db").toFile().getAbsolutePath();
    public final String host = "127.0.0.1";
    public final int port = 0;
    public final boolean skipServerCreation = false;
    public final String username = "Default User";
    public final String password = "";
    public final int connectionReconnectCount;
    public final int connectionThreadCount;
    public final int connectionSaveCount;
    public final int connectionInstanceCount;
    public final int modellingLoopCount;
    public final int modellingOpCount;
    public final String textIndexingFile;
    public final int rwQueryThreds;
    public final int rwQueryCount;
    public final int importOuterCount;
    public final int importInnerCount;
    public final int cachedClusterCount;
    public final int cachedClusterRounds;
    public final int generateCount;
    public final String generateModel;
    public final int publishLoopCount;
    public final int collectedLoopCount;
    public final int refreshLoopCount;
    public final int refreshAddCount;
    public final int callLoopCount;
    public final int callCallCount;
    public final int callThreadCount;
    public final int i3199ResourceCount;
    public final int i3176BlockCount;
    public final int i3176BigBlockCount;
    public final int i1659LoopCount;
    public final String databaseInitFile = "graph.txt";
    private static Configuration current = new Configuration();

    protected Configuration() {
        String configuration = System.getProperty("test.configuration", "regression");
        this.virtual = System.getProperty("test.graph.impl", "").equals("virtual");
        this.transactionKeep = System.getProperty("test.transaction.policy", "keep").equals("keep");
        this.useFailedTests = System.getProperty("test.use.failed", "false").equals("true");
        System.getProperty("test.exit.timeout", "30000");
        if (configuration.equals("stress")) {
            this.connectionReconnectCount = 100;
            this.connectionThreadCount = 10;
            this.connectionSaveCount = 10;
            this.connectionInstanceCount = 10;
            this.modellingLoopCount = 1000;
            this.modellingOpCount = 1000;
            this.textIndexingFile = "./data/cprrn10.txt";
            this.rwQueryThreds = 10;
            this.rwQueryCount = 1000000;
            this.importOuterCount = 10;
            this.importInnerCount = 100000;
            this.cachedClusterCount = 4096;
            this.cachedClusterRounds = 10;
            this.generateCount = 1000;
            this.generateModel = "devs";
            this.publishLoopCount = 200;
            this.collectedLoopCount = 1000;
            this.refreshLoopCount = 2;
            this.refreshAddCount = 1000000;
            this.callLoopCount = 2;
            this.callCallCount = 100000;
            this.callThreadCount = 100;
            this.i3199ResourceCount = 100000000;
            this.i3176BlockCount = 1000;
            this.i3176BigBlockCount = 5000;
            this.i1659LoopCount = 100;
        } else {
            this.connectionReconnectCount = 2;
            this.connectionThreadCount = 1;
            this.connectionSaveCount = 1;
            this.connectionInstanceCount = 1;
            this.modellingLoopCount = 2;
            this.modellingOpCount = 100;
            this.textIndexingFile = "./data/cprrn00.txt";
            this.rwQueryThreds = 1;
            this.rwQueryCount = 100;
            this.importOuterCount = 10;
            this.importInnerCount = 100;
            this.cachedClusterCount = 10;
            this.cachedClusterRounds = 2;
            this.generateCount = 1;
            this.generateModel = "test";
            this.publishLoopCount = 2;
            this.collectedLoopCount = 1;
            this.refreshLoopCount = 2;
            this.refreshAddCount = 100;
            this.callLoopCount = 2;
            this.callCallCount = 100;
            this.callThreadCount = 10;
            this.i3199ResourceCount = 200000;
            this.i3176BlockCount = 2;
            this.i3176BigBlockCount = 10;
            this.i1659LoopCount = 10;
        }
    }

    public static Configuration get() {
        return current;
    }
}

