/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.simantics.DefaultChoiceUserAgent;
import org.simantics.PlatformUserAgent;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.management.SessionContext;
import org.simantics.db.management.SessionContextProvider;
import org.simantics.db.management.SingleSessionContextProviderSource;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.testing.common.AcornTestHandler;
import org.simantics.db.testing.common.DatabaseState;
import org.simantics.db.testing.common.TestSettings;
import org.simantics.db.testing.impl.Configuration;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.scl.osgi.SCLOsgi;

public class Tests {
    private static AcornTestHandler testHandler;

    public static boolean contains(Collection<Statement> stms, Resource predicate, Resource object) {
        for (Statement stm : stms) {
            if (!stm.getPredicate().equals(predicate) || !stm.getObject().equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection<Statement> stms, Resource subject, Resource predicate, Resource object) {
        for (Statement stm : stms) {
            if (!stm.getSubject().equals(subject) || !stm.getPredicate().equals(predicate) || !stm.getObject().equals(object)) continue;
            return true;
        }
        return false;
    }

    public static DatabaseState freshWorkspace(String CORE_DIR, ArrayList<String> fileFilter) throws Exception {
        SimanticsPlatform.INSTANCE.resetWorkspace(null, fileFilter);
        return Tests.newSimanticsWorkspace(null, CORE_DIR);
    }

    public static void freshDatabase() throws Exception {
        DatabaseState state = Tests.freshWorkspace(Configuration.get().coreDir, null);
        Tests.shutdown(state);
    }

    public static DatabaseState existingDatabase() throws Exception {
        return Tests.oldSimanticsWorkspace(null, Configuration.get().coreDir);
    }

    private static void initSimanticsStuff() {
        SessionContextProvider provider = new SessionContextProvider(null);
        SingleSessionContextProviderSource source = new SingleSessionContextProviderSource((ISessionContextProvider)provider);
        Simantics.setSessionContextProviderSource((ISessionContextProviderSource)source);
        SimanticsInternal.setSessionContextProviderSource((ISessionContextProviderSource)source);
    }

    public static DatabaseState newSimanticsWorkspace(TestSettings testSettings, String address) throws Exception {
        AcornTestHandler testHandler = Tests.getTestHandler(testSettings, address);
        testHandler.initNew();
        Tests.initSimanticsStuff();
        SessionContext sessionContext = SimanticsPlatform.INSTANCE.startUp(Simantics.getDefaultDatabaseDriver(), null, SimanticsPlatform.RecoveryPolicy.FixError, SimanticsPlatform.OntologyRecoveryPolicy.Merge, true, (PlatformUserAgent)new DefaultChoiceUserAgent());
        return new DatabaseState(address, sessionContext);
    }

    public static DatabaseState oldSimanticsWorkspace(TestSettings testSettings, String address) throws Exception {
        Tests.getTestHandler(testSettings, address);
        Tests.initSimanticsStuff();
        SessionContext sessionContext = SimanticsPlatform.INSTANCE.startUp(Simantics.getDefaultDatabaseDriver(), null, SimanticsPlatform.RecoveryPolicy.FixError, SimanticsPlatform.OntologyRecoveryPolicy.Merge, false, null);
        return new DatabaseState(address, sessionContext);
    }

    public static void shutdown(DatabaseState state) throws Exception {
        if (SCLOsgi.MODULE_REPOSITORY != null) {
            SCLOsgi.MODULE_REPOSITORY.flush();
        }
        SCLOsgi.SOURCE_REPOSITORY = null;
        SCLOsgi.MODULE_REPOSITORY = null;
        SCLOsgi.TEST_REPOSITORY = null;
        if (Platform.isRunning()) {
            SimanticsPlatform.INSTANCE.shutdown(null);
            return;
        }
        if (state == null) {
            return;
        }
        String address = state.getAddress();
        try {
            if (address != null) {
                Tests.getTestHandler(null, address).getManagement().shutdown();
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public static void initOntology(Session session, String relative) throws DatabaseException {
        TransferableGraph1 layer0;
        Binding binding;
        try {
            binding = Bindings.getBinding(TransferableGraph1.class);
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
        File t = new File(TestSettings.getInstance().getWorkspace(), relative);
        if (!t.exists()) {
            throw new DatabaseException("File does not exist. File=" + t + ".");
        }
        try {
            FileInputStream is = new FileInputStream(t);
            layer0 = (TransferableGraph1)Files.readFile((InputStream)is, (Binding)binding);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseException((Throwable)e);
        }
        try {
            TransferableGraphs.importGraph((Session)session, (Object)layer0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new DatabaseException("Failed to init db.", e);
        }
    }

    public static AcornTestHandler getTestHandler() throws DatabaseException {
        return Tests.getTestHandler(null, null);
    }

    public static AcornTestHandler getTestHandler(TestSettings testSettings, String address) throws DatabaseException {
        if (testHandler == null) {
            testHandler = new AcornTestHandler(testSettings, address);
        }
        return testHandler;
    }

    public static void closeSession(Session session) throws DatabaseException {
        try {
            LifecycleSupport support = (LifecycleSupport)session.getService(LifecycleSupport.class);
            support.close(-1L, false);
            session = null;
        }
        catch (Exception exception) {
            session = null;
            throw new DatabaseException("Session did not close cleanly.");
        }
    }

    public static void killCore() throws DatabaseException {
    }
}

