/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.util.EnumSet;
import java.util.HashSet;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.simantics.db.testing.annotation.Always;
import org.simantics.db.testing.annotation.Fails;
import org.simantics.db.testing.annotation.Obsolete;
import org.simantics.db.testing.common.Failures;
import org.simantics.utils.FileUtils;

public class RegressionFilter
extends Filter {
    public static final String CLASSIFICATION_KEY = "regressionFilterClassification";
    public static final String CLASSIFICATION_KEY_1 = "1";
    public static final String CLASSIFICATION_KEY_2 = "2";
    public static final String CLASSIFICATION_KEY_3 = "3";
    public static final String CLASSIFICATION_KEY_4 = "4";
    private Failures tests;
    EnumSet<Classification> ALWAYS_CLASSES = EnumSet.of(Classification.REGRESSION1, Classification.REGRESSION2, Classification.ALWAYS);

    public RegressionFilter() {
        this.getTestCaseNames();
    }

    public String describe() {
        return "Filters out all failing tests.";
    }

    public Classification classify(Description d) {
        String testName = d.getDisplayName();
        Always a = (Always)d.getAnnotation(Always.class);
        if (a != null) {
            return Classification.ALWAYS;
        }
        Obsolete o = (Obsolete)d.getAnnotation(Obsolete.class);
        if (o != null) {
            return Classification.REGRESSION4;
        }
        Fails f = (Fails)d.getAnnotation(Fails.class);
        if (f != null) {
            return Classification.REGRESSION3;
        }
        Test t = (Test)d.getAnnotation(Test.class);
        if (t == null) {
            return Classification.ALWAYS;
        }
        if (this.tests == null) {
            return Classification.REGRESSION1;
        }
        int i = 0;
        while (i < this.tests.names.length) {
            if (testName.contains(this.tests.names[i])) {
                return Classification.REGRESSION2;
            }
            ++i;
        }
        return Classification.REGRESSION1;
    }

    private Classification getPass() {
        String s = System.getProperty(CLASSIFICATION_KEY);
        if (CLASSIFICATION_KEY_1.equals(s)) {
            return Classification.REGRESSION1;
        }
        if (CLASSIFICATION_KEY_2.equals(s)) {
            return Classification.REGRESSION2;
        }
        if (CLASSIFICATION_KEY_3.equals(s)) {
            return Classification.REGRESSION3;
        }
        if (CLASSIFICATION_KEY_4.equals(s)) {
            return Classification.REGRESSION4;
        }
        return null;
    }

    public boolean shouldRun(Description d) {
        Classification cls = this.classify(d);
        if (Classification.ALWAYS == cls) {
            return true;
        }
        Classification pass = this.getPass();
        if (pass == null && this.ALWAYS_CLASSES.contains((Object)cls)) {
            return true;
        }
        return pass == cls;
    }

    private void getTestCaseNames() {
        if (this.tests != null) {
            return;
        }
        try {
            String csv = FileUtils.getContents((String)"failures.dat").replace("\r", "");
            this.tests = new Failures();
            HashSet<String> ss = new HashSet<String>();
            String[] stringArray = csv.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.isEmpty()) {
                    ss.add(s);
                }
                ++n2;
            }
            this.tests.names = ss.toArray(new String[ss.size()]);
        }
        catch (Exception exception) {
            this.tests = new Failures();
            this.tests.names = new String[0];
        }
    }

    static enum Classification {
        REGRESSION1,
        REGRESSION2,
        REGRESSION3,
        REGRESSION4,
        ALWAYS;

    }
}

