/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.testing.base;

import org.junit.After;
import org.junit.Before;
import org.simantics.db.testing.common.TestBase;
import org.simantics.db.testing.common.Tests;

/**
 * Base class for Simantics Test Cases. Starts ProCore at the beginning of the
 * tests and closes it after tests are done.
 *
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ExistingDatabaseTest extends TestBase {

    @Before
    public void setUp() throws Exception {
        state = Tests.existingDatabase();
        super.setUp();
    }
    @After
    public void tearDown() throws Exception {
    	Tests.shutdown(state);
        state = null;
        super.tearDown();
    }
    public void reconnect() throws Exception {
    	setPrintStart(false);
        tearDown();
        setUp();
    	setPrintStart(true);
    }
}
