/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

/**
 * Interface for listening DB events.
 * 
 * Note: At the moment, only "purge" is supported.
 * 
 * @author luukkainen
 *
 */
public interface EventSupport {
    
    public void addListener(EventListener l);
    
    public void removeListener(EventListener l);

    
    public interface EventListener extends java.util.EventListener {
        /**
         * 
         * @param type Type of the event.
         * @param data Data related to the event, may be null.
         */
        public void event(String type, Object data);
    }
}
