/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import java.util.Collection;

import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.GraphChangeListenerSupport;

/**
 * A representation of a set of changes that have been performed into the graph
 * database using a write request ({@link Write}, {@link WriteOnly}).
 * 
 * <p>
 * The change information is allowed to be inexact in the sense that these
 * changes may represent what is attempted to commit into the database but some
 * of the changes may turn out to be null operations in the end: a claimed
 * statement may have already existed or a denied statement may not exist in the
 * first place. Hence, a ChangeSet tells what statement changes have possibly
 * been performed and what resource-bound values have possibly changed.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see GraphChangeListenerSupport
 * @see ChangeListener
 * @see ChangeEvent
 */
public interface ChangeSet {

    public interface StatementChange extends Statement {
        /**
         * @return <code>true</code> if the statement was claimed,
         *         <code>false</code> if denied.
         */
        boolean isClaim();
    }

    /**
     * TODO: specify whether the collection is considered a set or a list
     * (duplicate statements allowed or not)
     * 
     * The returned collection may be shared internal state of the
     * implementation and must not be modified by the client.
     * 
     * @return the set of changed statements, each either claimed or denied
     */
    Collection<StatementChange> changedStatements();

    /**
     * TODO: specify whether the collection is considered a set or a list
     * (duplicate statements allowed or not)
     * 
     * The returned collection may be shared internal state of the
     * implementation and must not be modified by the client.
     * 
     * @return the set of changed values, either claimed or denied
     */
    Collection<Resource> changedValues();
    
    Collection<Resource> changedResources();

    /**
     * @return <code>true</code> if this change set contains 0 operations,
     *         <code>false</code> otherwise
     */
    boolean isEmpty();

}
