/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Session;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.services.adaption.AdapterRegistry2;
import org.simantics.db.services.adaption.AdaptionService2;
import org.simantics.db.services.internal.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class AdaptionServiceInitializer implements ServiceInitializer {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptionServiceInitializer.class);

    public IStatus initialize(final Session s) {
        LOGGER.info("Initializing");
        AdaptionService2 service = new AdaptionService2();
        s.registerService(AdaptionService.class, service);
        try {
        	AdapterRegistry2 registry = new AdapterRegistry2();
        	registry.initialize(Activator.getDefault().getContext());
            LOGGER.info("Updating");
            registry.updateAdaptionService(s, service);
            return Status.OK_STATUS;
        } catch (DatabaseException e) {
            IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "AdaptionRegistry2 instantiation failed, see exception for details.", e);
            return status;
        }
    }

}