/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class GetChangeSetContextFunction extends AbstractFunction {
    public long changeSetId = 0;
    public byte[] changeSetContext = null;
    public GetChangeSetContextFunction() {
        super(MessageNumber.GetChangeSetContextRequest, MessageNumber.GetChangeSetContextResponse);
    }
    public GetChangeSetContextFunction(long changeSetId) {
        super(MessageNumber.GetChangeSetContextRequest, MessageNumber.GetChangeSetContextResponse);
        this.changeSetId = changeSetId;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(changeSetId);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        changeSetContext = dataBuffer.get(changeSetContext);
        gotResponse();
    }
}
