/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TIntShortHashMap;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

public class ClusterMapSmall {
    private TableSizeListener sizeListener;
    private ForeignTableSmall foreignTable;
    //private TObjectIntHashMap<ResourceUID> hashMap;
    private TIntShortHashMap hashMap;
    public ClusterMapSmall(TableSizeListener sizeListener, ForeignTableSmall foreignTable) {
        this.sizeListener = sizeListener;
        this.foreignTable = foreignTable;
        hashMap = null;
    }
    public ResourceUID getForeignResourceUID(short reference) {
        assert(reference >>> 15 > 0);
        short foreignIndex = (short)(reference ^ 1<<15);
        return foreignTable.getResourceUID(foreignIndex);
    }
    public void compact() {
        if(hashMap == null) return;
        hashMap.compact();
        sizeListener.resized();
    }
    public int getUsedSpace() {
        if(hashMap == null) return 0;
        int size = hashMap.size();
        int cap = hashMap.capacity();
        // int[], Object[], actual objects
        return cap*(4+ObjectSizes.POINTER_SIZE)+size*ObjectSizes.ResourceUIDSize;
    }
   
    public short getForeignReferenceOrCreateByResourceKey(int resourceKey, ClusterUID uid) throws DatabaseException {
        if (null == hashMap)
            hashMap = foreignTable.getResourceHashMap();
        short foreignIndex = hashMap.get(resourceKey);
        if (0 == foreignIndex) {
            if (hashMap.size() >= ClusterTraitsSmall.FOREIGN_INDEX_MAX)
                throw new OutOfSpaceException("Out of space for foreign resources=" + hashMap.size());
            foreignIndex = foreignTable.createForeign(resourceKey, uid);
            hashMap.put(resourceKey, foreignIndex);
        }
        return foreignIndex;
    }

    public short getForeignReferenceOrZero(int resourceKey) throws DatabaseException {
        if (null == hashMap)
            hashMap = foreignTable.getResourceHashMap();
        return hashMap.get(resourceKey);
    }
    
    
}
