/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management;

import java.util.concurrent.TimeoutException;

import org.simantics.db.Session;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * A container for a database session. Also hosts a hint context that can be
 * used to carry arbitrary values around. A server activation can be attached to
 * an ISessionContext for information value only - ISessionContext will never
 * dispose or do anything else with it.
 * 
 * <p>
 * Disposal of an ISessionContext closes the session contained by this context.
 * Further use of this context is prohibited.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface ISessionContext extends IDisposable, IHintContext {

    void close() throws IllegalStateException, InterruptedException, TimeoutException;

//    /**
//     * @return the socket address this session is connected to
//     */
//    IServerAddress getAddress();

    /**
     * @return the database session contained by this context
     * @throws IllegalStateException if this context has been disposed
     */
    Session getSession();

    /**
     * @return the database session contained by this context or
     *         <code>null</code> if session context has already been disposed.
     */
    Session peekSession();

}
