package org.simantics.db.layer0.variable;

import java.util.Objects;

import org.simantics.databoard.type.Datatype;

/**
 * @author Tuukka Lehtonen
 */
public class VariableReference {

    public final RVI variableId;

    public final Datatype datatype;

    public String label;

    public static VariableReference of(RVI variableId, Datatype datatype, String label) {
        return new VariableReference(variableId, datatype, label);
    }

    public VariableReference(RVI variableId, Datatype datatype, String label) {
        if (variableId == null)
            throw new NullPointerException("null variable reference");
        this.variableId = variableId;
        this.datatype = datatype;
        this.label = label;
    }
    
    public RVI getVariableId() {
        return variableId;
    }

    public Datatype getDatatype() {
        return datatype;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(datatype) * 31 + variableId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        VariableReference other = (VariableReference) obj;
        return variableId.equals(other.variableId) && Objects.equals(datatype, other.datatype);
//                && Objects.equals(label, other.label);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(variableId);
        if (datatype != null)
            sb.append(" : ").append(datatype.toSingleLineString());
        if (label != null)
            sb.append(" (").append(label).append(")");
        return sb.toString();
    }

}
