package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class StandardVariableBuilder<Node> implements VariableBuilder<Node> {

    private static StandardVariableBuilder<?> INSTANCE = null;

    private StandardVariableBuilder() {}

    public static synchronized StandardVariableBuilder<?> get() {
        if(INSTANCE == null) {
            INSTANCE = new StandardVariableBuilder<>();
        }
        return INSTANCE;
    }

    @Override
    public Variable buildChild(ReadGraph graph, Variable parent, VariableNode<Node> node, Resource child) {
        return new StandardGraphChildVariable(parent, node, child);
    }

    @Override
    public Variable buildProperty(ReadGraph graph, Variable parent, VariableNode<Node> node, Resource subject, Resource predicate) throws DatabaseException {
        return new StandardGraphPropertyVariable(graph, parent, node, subject, predicate);
    }

}
