package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;

public class StandardModelledPropertyVariable extends SimpleContextualAdapter<Variable, ModelledVariablePropertyDescriptor> {

	@Override
	public Variable adapt(ReadGraph graph, Resource source, ModelledVariablePropertyDescriptor context) throws DatabaseException {
		
		// Let the predicate provide an adapter if it wants
		
		Variable propertyAdapter = graph.getPossibleContextualAdapter(context.getProperty(), context, ModelledVariablePropertyDescriptor.class, Variable.class);
		if(propertyAdapter != null) return propertyAdapter; 
		
		// Fall back to standard
		return new StandardGraphPropertyVariable(graph, context.getVariable(), null, context.getSubject(), context.getProperty());
		
	}

}
