/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import gnu.trove.map.hash.THashMap;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;

public class UnescapedPropertyMapOfResource extends ResourceRead<Map<String, PropertyInfo>> {

	public UnescapedPropertyMapOfResource(Resource resource) {
	    super(resource);
	}

	@Override
	public Map<String,PropertyInfo> perform(ReadGraph graph) throws DatabaseException {

		Collection<Resource> predicates = graph.getPredicates(resource); 
        THashMap<String, PropertyInfo> result = new THashMap<String, PropertyInfo>(predicates.size());
		for(Resource predicate : predicates) {
			PropertyInfo info = graph.syncRequest(new PropertyInfoRequest(predicate), TransientCacheAsyncListener.<PropertyInfo>instance());
			if(info != null && info.isHasProperty) {
		        String name = info.name;
		        if (result.put(name, info) != null)
		        	System.err.println(this + ": The database resource $" + resource.getResourceId() + " contains siblings with the same name " + name + " (resource=$" + info.predicate.getResourceId() +").");
			}				
		}
		return result;
		
	}
	
}
