/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * Instantiates given type using templates attached to the type.
 * @author Hannu Niemist
 */
public class InstantiateRequest extends ApplyTemplatesRequest {
	Resource type;
	
	public InstantiateRequest(Resource type, Map<String, Object> parameters,
			Collection<Resource> contexts) {
		super(parameters, contexts);
		this.type = type;
	}
	
	public InstantiateRequest(Resource type, Map<String, Object> parameters) {
		super(parameters);
		this.type = type;
	}
	
	public InstantiateRequest(Resource type) {
		super();
		this.type = type;
	}

	public Resource perform(WriteGraph g) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
	
    	Resource parent = (Resource)parameters.get("parent");
    	if(parent != null) CommonDBUtils.selectClusterSet(g, parent);
    	
		// Default instantiation logic
		Resource instance = g.newResource();
		g.newClusterSet(instance);
		g.claim(instance, b.InstanceOf, null, type);
		
		perform(g, instance);
		
		return instance;
	}
}
