/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.indexing.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

/**
 * An internal in-memory container for telling whether a certain index has been
 * changed since the platform was last started up. 
 * 
 * @author Jussi Koskela
 * @since 1.28.0
 */
public class IndexChangedWriter {
	private Set<Path> dirtyFiles = new HashSet<>();

	public synchronized boolean markDirty(Path dirtyFile) throws IOException {
		return dirtyFiles.add(dirtyFile);
	}
}
