/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.indexing;

import org.eclipse.core.runtime.Platform;

/**
 * Contains indexing-related debugging and tracing flags.
 * 
 * @author Tuukka Lehtonen
 */
public final class IndexPolicy {

    // General debug flag for the plugin
    public static boolean DEBUG = false;

    public static boolean DEBUG_INDEX_INIT       = false;
    public static boolean TRACE_INDEX_MANAGEMENT = false;
    public static boolean TRACE_INDEX_INIT       = false;
    public static boolean TRACE_INDEX_LOAD       = false;
    public static boolean TRACE_INDEX_LOCKING    = false;
    public static boolean TRACE_INDEX_UPDATE     = false;
    public static boolean PERF_INDEX_INIT        = false;
    public static boolean PERF_INDEX_LOAD        = false;
    public static boolean PERF_INDEX_UPDATE      = false;
    public static boolean PERF_INDEX_QUERY       = false;

    static {
        if (Activator.getDefault().isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            DEBUG_INDEX_INIT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/debug/indexInit")); //$NON-NLS-1$
            TRACE_INDEX_MANAGEMENT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/trace/indexManagement")); //$NON-NLS-1$
            TRACE_INDEX_INIT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/trace/indexInit")); //$NON-NLS-1$
            TRACE_INDEX_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/trace/indexLoad")); //$NON-NLS-1$
            TRACE_INDEX_LOCKING = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/trace/indexLocking")); //$NON-NLS-1$
            TRACE_INDEX_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/trace/indexUpdate")); //$NON-NLS-1$
            PERF_INDEX_INIT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/perf/indexInit")); //$NON-NLS-1$
            PERF_INDEX_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/perf/indexLoad")); //$NON-NLS-1$
            PERF_INDEX_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/perf/indexUpdate")); //$NON-NLS-1$
            PERF_INDEX_QUERY = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.BUNDLE_ID + "/perf/indexQuery")); //$NON-NLS-1$
        }
    }

}
