/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.UnaryQueryPIntSet;

public final class Types
extends UnaryQueryPIntSet {
    public Types(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<IntSet> procedure) throws DatabaseException {
        Types.computeForEach(graph, this.id, this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, int id, Types entry, InternalProcedure<IntSet> procedure_) throws DatabaseException {
        InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;
        Types.computeForEach2(graph, id, entry, procedure);
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public static void computeForEach2(ReadGraphImpl graph, int id, final Types parent, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, id);
        int ret = processor.querySupport.getSingleInstance(id);
        if (ret > 0) {
            TypeHierarchy.queryEach(graph, ret, processor, parent, null, new InternalProcedure<IntSet>(){

                @Override
                public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                    procedure.execute(graph, types);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                    procedure.exception(graph, t);
                }
            });
            return;
        }
        int instanceOf = processor.getInstanceOf();
        int inherits = processor.getInherits();
        int subrelationOf = processor.getSubrelationOf();
        final IntSet result = new IntSet(processor.querySupport);
        final TIntProcedure addToResult = new TIntProcedure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(int r) {
                IntSet intSet = result;
                synchronized (intSet) {
                    result.add(r);
                }
                return true;
            }
        };
        final AtomicInteger finishes = new AtomicInteger(0);
        SyncIntProcedure instanceOfProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                if (finishes.addAndGet(1) == 3) {
                    procedure.execute(graph, result);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                result.add(i);
                this.inc();
                QueryCache.runnerSuperTypes(graph, i, parent, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        };
        SyncIntProcedure inheritsProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                int current = finishes.addAndGet(1);
                if (current == 3) {
                    procedure.execute(graph, result);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                this.inc();
                QueryCache.runnerTypes(graph, i, parent, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        };
        SyncIntProcedure subrelationOfProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                int current = finishes.addAndGet(1);
                if (current == 3) {
                    procedure.execute(graph, result);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                this.inc();
                QueryCache.runnerTypes(graph, i, parent, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        };
        processor.querySupport.getObjects(graph, id, instanceOf, instanceOfProcedure);
        instanceOfProcedure.finished(graph);
        processor.querySupport.getObjects(graph, id, inherits, inheritsProcedure);
        inheritsProcedure.finished(graph);
        processor.querySupport.getObjects(graph, id, subrelationOf, subrelationOfProcedure);
        subrelationOfProcedure.finished(graph);
    }

    public String toString() {
        return "Types[" + this.id + "]";
    }
}

