/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;

public final class PrincipalTypes
extends CollectionUnaryQuery {
    public PrincipalTypes(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, IntProcedure proc) throws DatabaseException {
        PrincipalTypes.computeForEach(graph, this.id, this, proc);
    }

    public static Object computeForEach(ReadGraphImpl graph, int id, PrincipalTypes entry, IntProcedure procedure_) throws DatabaseException {
        IntProcedure procedure = entry != null ? entry : procedure_;
        Object result = PrincipalTypes.computeForEach2(graph, id, entry, procedure);
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
        return result;
    }

    public static Object computeForEach2(final ReadGraphImpl graph, final int id, final PrincipalTypes parent, final IntProcedure procedure) throws DatabaseException {
        final QueryProcessor provider = graph.processor;
        provider.querySupport.ensureLoaded(graph, id);
        assert (id != 0);
        int ret = provider.querySupport.getSingleInstance(id);
        if (ret > 0) {
            procedure.execute(graph, ret);
            procedure.finished(graph);
            return ret;
        }
        int instanceOf = provider.getInstanceOf();
        int inherits = provider.getInherits();
        int subrelationOf = provider.getSubrelationOf();
        final Ints indirect = new Ints();
        final Ints material = new Ints();
        IntProcedure directProc = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                material.add(i);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                procedure.exception(graph, t);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        };
        IntProcedure indirectProc = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                indirect.add(i);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                procedure.exception(graph, t);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        };
        provider.querySupport.getObjects(graph, id, instanceOf, directProc);
        provider.querySupport.getObjects(graph, id, inherits, indirectProc);
        provider.querySupport.getObjects(graph, id, subrelationOf, indirectProc);
        if (indirect.size() == 0) {
            int size = material.size();
            if (size == 0) {
                procedure.finished(graph);
                return null;
            }
            if (size == 1) {
                int single = material.single;
                procedure.execute(graph, single);
                procedure.finished(graph);
                return single;
            }
            PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, parent, procedure);
            return null;
        }
        indirect.forEach(new TIntProcedure(){
            int finishes = 0;

            public boolean execute(int arg0) {
                try {
                    return this.execute0(arg0);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                    return false;
                }
            }

            public boolean execute0(int arg0) throws DatabaseException {
                if (arg0 == id) {
                    int current;
                    if ((current = ++this.finishes) == indirect.size()) {
                        int size = material.size();
                        if (size == 0) {
                            procedure.finished(graph);
                            return true;
                        }
                        if (size == 1) {
                            int single = material.single;
                            procedure.execute(graph, single);
                            procedure.finished(graph);
                            return true;
                        }
                        PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, parent, procedure);
                        return true;
                    }
                    return true;
                }
                QueryCache.runnerPrincipalTypes(graph, arg0, parent, null, new IntProcedure(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        Ints ints = material;
                        synchronized (ints) {
                            material.add(i);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        int current;
                        if ((current = ++finishes) == indirect.size()) {
                            int size = material.size();
                            if (size == 0) {
                                procedure.finished(graph);
                                return;
                            }
                            if (size == 1) {
                                int single = material.single;
                                procedure.execute(graph, single);
                                procedure.finished(graph);
                                return;
                            }
                            PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, parent, procedure);
                            return;
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                    }
                });
                return true;
            }
        });
        return null;
    }

    private static void finish(ReadGraphImpl graph, TIntHashSet rejects, int[] material, IntProcedure proc) throws DatabaseException {
        int[] nArray = material;
        int n = material.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!rejects.contains(i)) {
                proc.execute(graph, i);
            }
            ++n2;
        }
        proc.finished(graph);
    }

    private static void addPrincipalType(ReadGraphImpl graph, final TIntHashSet rejects, final int[] material, int index, final QueryProcessor provider, final PrincipalTypes parent, final IntProcedure proc) throws DatabaseException {
        if (index == material.length) {
            PrincipalTypes.finish(graph, rejects, material, proc);
            return;
        }
        int type = material[index++];
        while (rejects.contains(type)) {
            if (index == material.length) {
                PrincipalTypes.finish(graph, rejects, material, proc);
                return;
            }
            type = material[index++];
        }
        final int nextIndex = index;
        QueryCache.runnerSuperTypes(graph, type, parent, null, new InternalProcedure<IntSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ReadGraphImpl graph, IntSet supers) throws DatabaseException {
                TIntHashSet tIntHashSet = rejects;
                synchronized (tIntHashSet) {
                    supers.forEach(new TIntProcedure(){

                        public boolean execute(int arg0) {
                            rejects.add(arg0);
                            return true;
                        }
                    });
                }
                PrincipalTypes.addPrincipalType(graph, rejects, material, nextIndex, provider, parent, proc);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                proc.exception(graph, t);
            }
        });
    }

    public String toString() {
        return "PrincipalTypes[" + this.id + "]";
    }

    static class Ints {
        private TIntHashSet set = null;
        public int single = 0;

        Ints() {
        }

        public boolean add(int val) {
            if (this.single == val) {
                return false;
            }
            if (this.single == 0) {
                this.single = val;
                return true;
            }
            if (this.set == null) {
                this.set = new TIntHashSet(4);
            }
            this.set.add(val);
            return true;
        }

        public int size() {
            if (this.single == 0) {
                return 0;
            }
            if (this.set == null) {
                return 1;
            }
            return this.set.size() + 1;
        }

        public int[] toArray() {
            int[] result = Arrays.copyOf(this.set.toArray(), this.set.size() + 1);
            result[this.set.size()] = this.single;
            return result;
        }

        public void forEach(TIntProcedure proc) {
            proc.execute(this.single);
            if (this.set != null) {
                this.set.forEach(proc);
            }
        }
    }
}

