/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.databoard.Bindings;
import org.simantics.db.DevelopmentKeys;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.utils.Development;

public final class ValueQuery extends UnaryQueryP<byte[]> {

    public ValueQuery(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<byte[]> procedure) throws DatabaseException {
        computeForEach(graph, id, this, procedure);
    }

    public static byte[] computeForEach(ReadGraphImpl graph, final int r, final ValueQuery entry, final InternalProcedure<byte[]> procedure_) throws DatabaseException {

        if(Development.DEVELOPMENT) {
            if(Development.<Boolean>getProperty(DevelopmentKeys.QUERYPROCESSOR_PERFORM_QUERY, Bindings.BOOLEAN)) {
                Development.log("PQ ValueQuery " + r);
            }
        }
        
        InternalProcedure<byte[]> procedure = entry != null ? entry : procedure_;

        graph.ensureLoaded(r);

        byte[] value = graph.getValue(r);
        if(procedure != null) procedure.execute(graph, value);

        if(entry != null && procedure_ != null) entry.performFromCache(graph, procedure_);

        return value;

    }
    
    @Override
    public void serializeValue(QuerySerializer serializer) {
        byte[] result = getResult();
        if(result == null) {
            serializer.writeLE(-1);
        } else {
            serializer.writeLE(result.length);
            serializer.add(result);
        }
    }

    @Override
    public String toString() {
        return "Value[" + id + "]";
    }

}
