package org.simantics.db.impl.query;

import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;

public class RelationInfoQueryFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        RelationInfoQuery result = reference(deserializer);
        int r = deserializer.readResource();
        int isFunctional = deserializer.readByte();
        int isFinal = deserializer.readByte();
        int isAsserted = deserializer.readByte();
        RelationInfo ri = new RelationInfo(r, isFunctional == 1, isFinal == 1, isAsserted == 1);
        result.setResult(ri);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readRelationInfoQuery();
    }

}
