/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;

public abstract class CacheEntry<Procedure> {
	
    final public static int HAS_BEEN_BOUND = 1;

    abstract boolean isFresh();
    abstract boolean isReady();
    abstract boolean isRefuted();
    abstract boolean isPending();
    abstract boolean isDiscarded();
    abstract boolean isExcepted();

    abstract void setReady();
    abstract void refute();
    abstract void setPending(QuerySupport querySupport);
    abstract void discard();
    abstract void except(Throwable t);
    abstract void clearResult(QuerySupport support);

    abstract void prepareRecompute(QuerySupport querySupport);
    
    abstract public Object getOriginalRequest();
    abstract Query getQuery();

    abstract <T> T getResult();
    abstract void setResult(Object result);
    
    abstract Object performFromCache(ReadGraphImpl graph, Procedure procedure) throws DatabaseException;
    
    abstract boolean isImmutable(ReadGraphImpl graph) throws DatabaseException;
    
    abstract boolean shouldBeCollected();
    
    abstract short getLevel();
    abstract short setLevel(short level);
    
    abstract int getGCStatus();
    abstract int setGCStatus(int status);
    abstract void setGCStatusFlag(int flag, boolean value);

}
