package org.simantics.db.impl.graph;

import org.simantics.db.DevelopmentEvents.DenyValueEvent;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;

public class DenyValueEventImpl implements DenyValueEvent {

	final private VirtualGraph virtualGraph;
	final private Resource subject;
	final private Object value;
	final private String text;
	
	public DenyValueEventImpl(ReadGraph graph, VirtualGraph virtualGraph, Resource subject, Object value, String text) {
		this.virtualGraph = virtualGraph;
		this.subject = subject;
		this.value = value;
		this.text = text;
	}
	
	@Override
	public VirtualGraph getVirtualGraph() {
		return virtualGraph;
	}

	@Override
	public Resource getSubject() {
		return subject;
	}

	@Override
	public Object getValue() {
		return value;
	}
	
	@Override
	public String toString() {
		return text;
	}
	
}
