package org.simantics.db.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.SyncContextMultiProcedure;

public final class ForEachObjectContextProcedure<C> implements SyncContextMultiProcedure<C, Resource> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final QueryProcessor processor;
	public final ClusterI.CompleteTypeEnum completeType;
	private final SyncContextMultiProcedure<C, Resource> user;
	
	public ForEachObjectContextProcedure(int predicateKey, RelationInfo info, QueryProcessor processor, SyncContextMultiProcedure<C, Resource> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.processor = processor;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(ReadGraph graph, C context, Resource result) throws DatabaseException {
		user.execute(graph, context, result);
	}

	@Override
	public void finished(ReadGraph graph, C context) throws DatabaseException {
		user.finished(graph, context);
	}

	@Override
	public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
		user.exception(graph, throwable);
	}
	
}
