package org.simantics.db.common.utils.traverser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.Resource;

/**
 * Class for building traverse queries
 *
 * @author toni.kalajainen@semantum.fi
 */
public class TraverseQueryBuilder {

	private final static Resource[] NO_RESOURCES = new Resource[0];
	
    public Set<Resource> startResources = new HashSet<Resource>();
    public Set<Resource> relationsToFollow = new HashSet<Resource>();
    public Set<Resource> instanceOfToFollowTo = new HashSet<Resource>();
    public Set<Resource> instanceOfToAddToResult = new HashSet<Resource>();
    public Set<Resource> inheritedFromToFollowTo = new HashSet<Resource>();
    public Set<Resource> inheritedFromToAddToResult = new HashSet<Resource>();

    
    public void setStartResource(Resource r) {
    	startResources.clear();
    	startResources.add(r);
    }
    
    public void setStartResources(Collection<Resource> r) {
    	startResources.clear();
    	startResources.addAll(r);
    }
    
    public void addStartResource(Resource r) {
    	startResources.add(r);
    }
    
    public void followInstanceOf(Resource r) {
    	instanceOfToFollowTo.add(r);
    }
    
    public void followInheritedFrom(Resource r) {
    	inheritedFromToFollowTo.add(r);
    }
    
    public void followRelation(Resource r) {
    	relationsToFollow.add(r);
    }
    
    public void returnInstanceOf(Resource r) {
    	instanceOfToAddToResult.add(r);
    }

    public void returnInheritedFrom(Resource r) {
    	inheritedFromToAddToResult.add(r);
    }
    
    public void followAndReturnInstanceOf(Resource r) {
    	instanceOfToFollowTo.add(r);
    	instanceOfToAddToResult.add(r);
    }
    
    public void followAndReturnInheritedFrom(Resource r) {
    	inheritedFromToFollowTo.add(r);
    	inheritedFromToAddToResult.add(r);
    }
    
    
    public void clear() {
    	startResources.clear();
    	instanceOfToFollowTo.clear();
    	relationsToFollow.clear();
    	instanceOfToAddToResult.clear();
    }
    
    public TraverseQuery build() {
    	return new TraverseQuery(
    		startResources.toArray( NO_RESOURCES ),
    		instanceOfToFollowTo.toArray( NO_RESOURCES ),
    		relationsToFollow.toArray( NO_RESOURCES ),
    		instanceOfToAddToResult.toArray( NO_RESOURCES ),
    		inheritedFromToFollowTo.toArray( NO_RESOURCES ),
    		inheritedFromToAddToResult.toArray( NO_RESOURCES )
    	);
    }

	
}
