/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PossibleTypedParent extends ResourceRead2<Resource> {

	public PossibleTypedParent(Resource resource, Resource type) {
		super(resource, type);
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
		if (graph.isInstanceOf(resource, resource2)) {
			return resource;
		} else {
			Layer0 L0 = Layer0.getInstance(graph);
			Resource possibleParent = graph.getPossibleObject(resource, L0.PartOf);
			if (possibleParent != null) {
				return graph.syncRequest(new PossibleTypedParent(possibleParent, resource2));
			} else {
				return null;
			}
		}
	}

}
