/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.literal;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.binary.Endian;

public class GUID
extends Bean {
    public static final Binding BINDING = Bindings.getBindingUnchecked(GUID.class);
    public long mostSignificant;
    public long leastSignificant;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public GUID(long mostSignificant, long leastSignificant) {
        super(BINDING);
        this.mostSignificant = mostSignificant;
        this.leastSignificant = leastSignificant;
    }

    public GUID(byte[] array, int offset) {
        this.mostSignificant = Endian.readLong((byte[])array, (int)offset);
        this.leastSignificant = Endian.readLong((byte[])array, (int)(offset + 8));
    }

    public static GUID invalid() {
        return new GUID(0L, 0L);
    }

    public static GUID invalid2() {
        return new GUID(0L, 1L);
    }

    public boolean isInvalid() {
        return this.mostSignificant == 0L && this.leastSignificant == 0L;
    }

    public static GUID random() {
        UUID random = UUID.randomUUID();
        return new GUID(random.getMostSignificantBits(), random.getLeastSignificantBits());
    }

    public String indexString() {
        return GUID.indexString(this.mostSignificant, this.leastSignificant);
    }

    public static String possibleIndexString(byte[] array, int offset, String defaultValue) {
        if (array == null) {
            return defaultValue;
        }
        int bytes = array.length - offset;
        if (bytes < 16) {
            return defaultValue;
        }
        long ms = Endian.readLong((byte[])array, (int)offset);
        long ls = Endian.readLong((byte[])array, (int)(offset + 8));
        return GUID.indexString(ms, ls);
    }

    public static String indexString(long mostSignificant, long leastSignificant) {
        byte[] buf = new byte[33];
        int len1 = GUID.toUnsignedString0(mostSignificant, 4, buf, 0);
        buf[len1] = 95;
        int len2 = GUID.toUnsignedString0(leastSignificant, 4, buf, len1 + 1);
        return new String(buf, 0, len1 + 1 + len2, StandardCharsets.US_ASCII);
    }

    public static GUID parseIndexString(String indexString) {
        String[] parts = indexString.split("_");
        if (parts.length != 2) {
            throw new IllegalArgumentException();
        }
        Long mostSignificant = GUID.parseUnsignedLong(parts[0].toUpperCase(), 16);
        Long leastSignificant = GUID.parseUnsignedLong(parts[1], 16);
        return new GUID(mostSignificant, leastSignificant);
    }

    private static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = Long.parseLong(s.substring(0, len - 1), radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s);
            }
            long result = first * (long)radix + (long)second;
            if (GUID.compareUnsigned(result, first) < 0) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return result;
        }
        throw new NumberFormatException("For input string: \"" + s + "\"");
    }

    private static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    private static int toUnsignedString0(long val, int shift, byte[] out, int offset) {
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        GUID.formatUnsignedLong0(val, shift, out, offset, chars);
        return chars;
    }

    private static void formatUnsignedLong0(long val, int shift, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = (byte)digits[(int)val & mask];
            val >>>= shift;
        } while (charPos > offset);
    }
}

