package org.simantics.datatypes.utils;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;

final public class BTreeContentBean extends Bean {
	public static int counter = 0;
	public boolean leaf;
	public int n;
	public PossibleVariant[] key;
	public PossibleResource[] value;
	public PossibleResource[] c;
	public BTreeContentBean() {
	}
	public static BTreeContentBean create(int t) {
		BTreeContentBean result = new BTreeContentBean();
		result.leaf = true;
		result.n = 0;
		result.key = new PossibleVariant[2*t-1];
		result.value = new PossibleResource[2*t-1];
		for(int i=0;i<2*t-1;i++) {
			result.key[i] = new PossibleVariant();
			result.value[i] = new PossibleResource();
		}
		result.c = new PossibleResource[2*t];
		for(int i=0;i<2*t;i++) result.c[i] = new PossibleResource();
		return result;
	}
	
	public void reduceSize() {
		assert (n > 0);
		key[n - 1] = new PossibleVariant();
		value[n - 1] = new PossibleResource();
		c[n] = new PossibleResource();
		n--;
	}
	
	public Variant getKey(int index) {
		return key[index].v;
	}

	public Resource getValue(int index) {
		return value[index].r;
	}

	public Resource getChild(int index) {
		return c[index].r;
	}

	public static BTreeContentBean readPossible(ReadGraph graph, Resource r) throws DatabaseException {
    	DatatypeResource DATA = DatatypeResource.getInstance(graph);
		SerialisationSupport ss = graph.getService(SerialisationSupport.class);
		XSupport xs = graph.getService(XSupport.class);
		BTreeContentBinding CONTENT_BEAN_BINDING = new BTreeContentBinding(ss, xs);
		return graph.syncRequest(new PossibleRelatedValue<BTreeContentBean>(r, DATA.BTreeNode_content, CONTENT_BEAN_BINDING), TransientCacheListener.<BTreeContentBean>instance());
	}
	
	
}