/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.units;

public class LinearConverter implements IUnitConverter {
	double scale;
	
	public LinearConverter(double scale) {
		this.scale = scale;
	}

	@Override
	public double convert(double value) {
		return value*scale;
	}

	@Override
	public String toString() {
	    if(scale == 1.0)
			return "v -> v";
		else
			return "v -> " + scale + "*v";
	}
	
}
