/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import java.util.Set;

import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;

/**
 * MutableVariantBinding binds VariantType to {@link MutableVariant} Class. 
 */
public class MutableVariantBinding extends ImmutableVariantBinding {
		
	public MutableVariantBinding(ClassBindingFactory bindingFactory, AdapterFactory adapterFactory) {
		super(bindingFactory, adapterFactory);
	}
	
	@Override
	public Object create(Binding binding, Object value) throws BindingException {
		return new MutableVariant(binding, value);
	}
	
	@Override
	public boolean isImmutable() {
		return false;
	}

	@Override
	public boolean isInstance(Object obj) {
		if (obj==null) return false;
		if (obj instanceof MutableVariant == false) return false;
		return true;
	}
	
	@Override
	public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
		if (obj==null) throw new BindingException("null value is not MutableVariant");
		if (obj instanceof MutableVariant == false) throw new BindingException("wrong class, MutableVariant expected");
		MutableVariant var = (MutableVariant) obj;
		if (var.binding==null) throw new BindingException("Binding is expected");		
		var.binding.assertInstaceIsValid(var.value, validInstances);
	}
	
	@Override
	public void setContent(Object variant, Binding binding, Object value)
			throws BindingException {
		assert(isValid(binding, value));
		MutableVariant var = (MutableVariant) variant;
		var.binding = binding;
		var.value = value;
	}

}
