/*******************************************************************************
s *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableBoolean;
import org.simantics.databoard.type.BooleanType;

/**
 * Binds BooleanType to {@link MutableBoolean}
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MutableBooleanBinding extends BooleanBinding {
	
	public MutableBooleanBinding(BooleanType type) {
		super(type);
	}

	public Object create(boolean value) {
		MutableBoolean result = new MutableBoolean();
		result.value = value;
		return result;
	}
	
	public Object create(Boolean value) {
		MutableBoolean result = new MutableBoolean();
		result.value = value;
		return result;
	}
	
	@Override
	public void setValue(Object obj, boolean newValue) throws BindingException {
		MutableBoolean result = (MutableBoolean) obj;
		result.value = newValue;
	}
	
	@Override
	public void setValue(Object obj, Boolean newValue) throws BindingException {
		MutableBoolean result = (MutableBoolean) obj;
		result.value = newValue;
	}
	
	public Boolean getValue(Object o) {
		return ((MutableBoolean)o).value;
	}
	
	@Override
	public boolean getValue_(Object o) {
		return ((MutableBoolean)o).value;
	}
	
    @Override
	public boolean isInstance(Object obj) {
		return obj instanceof MutableBoolean;
	}
	
	
}


