package org.simantics.databoard.binding.factory;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.RecordType;

/**
 * Binds RecordType to Object[]
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
class RecordObjectArrayBinding extends RecordBinding {

	public RecordObjectArrayBinding(RecordType type, Binding[] componentBindings)
	{
		this.componentBindings = componentBindings;
        if (type==null) throw new IllegalArgumentException("null arg");
		this.type = type;
	}
		
	@Override
	public Object create(Object... value) {		
		return value;
	}
	
	@Override
	public Object createPartial() {
		return new Object[getComponentCount()];
	}
	
	@Override
	public Object getComponent(Object obj, int index) {
		return ((Object[])obj)[index];
	}

	@Override
	public void setComponents(Object obj, Object... value) throws BindingException {
		System.arraycopy(value, 0, obj, 0, value.length);
	}
	
	@Override
	public void setComponent(Object obj, int index, Object value)
			throws BindingException {
		Object[] array = (Object[]) obj;
		array[index] = value;
	}

	@Override
	public boolean isInstance(Object obj) {
		return (obj instanceof Object[]) && (((Object[])obj).length == componentBindings.length);
	}
	
}