package org.simantics.charts.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.SetProperty;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class TrackExperimentTimeAction extends Action {

    private Resource chart;
    private Boolean currentValue;

    public TrackExperimentTimeAction(String name, Resource chart, boolean currentValue) {
        super(name, Action.AS_CHECK_BOX);
        this.chart = chart;
        this.currentValue = currentValue;
        setChecked(currentValue);
    }

    @Override
    public void run() {
        setTracking(chart, !currentValue);
    }

    public static void setTracking(Resource chart, boolean newValue) {
        try {
            Session session = Simantics.getSession();
            ChartResource CHART = ChartResource.getInstance(session);
            session.markUndoPoint();
            session.syncRequest(new SetProperty(chart, CHART.Chart_trackExperimentTime, newValue, Bindings.BOOLEAN));
        } catch (DatabaseException e) {
            Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to set track experiment time.", e));
        }
    }

}