/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import java.util.concurrent.CopyOnWriteArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;

public class WidgetSupportFactory {

	public static WidgetSupport projectSupport() {
		
		return new WidgetSupport() {

			final private CopyOnWriteArrayList<Widget> widgets = new CopyOnWriteArrayList<Widget>();

			@Override
			public synchronized void register(Widget widget) {
				widgets.add(widget);
			}
			
			@Override
			public void update(Widget widget) {
				throw new Error("Not implemented.");
			}

			@Override
			public void update() {
				throw new Error("Not implemented.");
			}
			
			@Override
			public <T> T getInput() {
				throw new Error("Not implemented.");
			}
			
			@Override
			public void finish() {
			    Resource project = Simantics.peekProjectResource();
			    if(project == null) return;
				ISelection input = new StructuredSelection(project);
				fireInput(Simantics.getSessionContext(), input);
			}
			
			public void fireInput(ISessionContext context, Object input) {
				for(Widget widget : widgets) widget.setInput(context, input);
			}
			
			@Override
			public <T> T getParameter(String key) {
				throw new Error("Not implemented.");
			}
			
			@Override
			public void setParameter(String key, Object value) {
				throw new Error("Not implemented.");
			}

			@Override
			public <T> T getInput(ReadGraph graph) {
				throw new Error("Not implemented.");
			}
			
		};
		
	}
	
}
