/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;


public class StringPropertyModifier extends TextModifyListenerImpl<Resource> {

	final private String propertyURI;
	final private boolean undo;
	public StringPropertyModifier(ISessionContext context, String propertyURI) {
		this(context, propertyURI,true);
	}
	
	public StringPropertyModifier(ISessionContext context, String propertyURI, boolean undo) {
		this.propertyURI = propertyURI;
		this.undo = undo;
	}

	@Override
	public void applyText(WriteGraph graph, Resource issue, String text) throws DatabaseException {
		if (undo) {
			String meta =  propertyURI;
			int i = propertyURI.lastIndexOf("/");
			if (i > 0)
				meta = meta.substring(i+1);
			Layer0Utils.addCommentMetadata(graph, "Modify String " +meta);
			graph.markUndoPoint();
		}
		graph.claimLiteral(issue, graph.getResource(propertyURI), text, Bindings.STRING);
		
	}
	
}