/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.swt.widgets.impl.MouseListenerImpl;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

abstract public class ExplorerMouseListenerImpl<T> extends MouseListenerImpl<T> {

	private GraphExplorer explorer = null;
	private ISelection selection;
	
	public ExplorerMouseListenerImpl(ISessionContext context) {
		super(context);
	}
	
	void register(GraphExplorer explorer) {
		this.explorer = explorer;
	}
	
	public void doubleClick(WriteGraph graph, T input) throws DatabaseException {

		if(explorer == null) return;
		
		doubleClick(graph, input, selection);
			
	}
	
	@Override
	public void beforeApply(T input) {
		
		if(explorer == null) return;
		
		IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
		selection = selectionProvider.getSelection();
		
	}

	abstract public void doubleClick(WriteGraph graph, T input, ISelection selection) throws DatabaseException;
	
}
	