/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;

public class DefaultColorProvider implements ITrackedColorProvider {
	
	private final ResourceManager resourceManager;
	
    private final ColorDescriptor highlightColor = ColorDescriptor.createFrom(new RGB(254, 255, 197));
    private final ColorDescriptor inactiveColor = ColorDescriptor.createFrom(new RGB(245, 246, 190));
    private final ColorDescriptor invalidInputColor = ColorDescriptor.createFrom(new RGB(255, 128, 128));

    public DefaultColorProvider(ResourceManager resourceManager) {
    	this.resourceManager = resourceManager;
    }
    
    @Override
    public Color getEditingBackground() {
        return null;
    }

    @Override
    public Color getHoverBackground() {
        return resourceManager.createColor(highlightColor);
    }

    @Override
    public Color getInactiveBackground() {
        return resourceManager.createColor(inactiveColor);
    }

    @Override
    public Color getInvalidBackground() {
        return resourceManager.createColor(invalidInputColor);
    }

}


