/*******************************************************************************
 *  Copyright (c) 2013 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.graph.impl.contribution.LabelDecoratorContributionImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class PropertyLabelDecoratorFactory implements LabelDecoratorFactory {

	private final static ColorDescriptor READONLY_GRAY = ColorDescriptor.createFrom(new RGB(240, 240, 240));

	@Override
	public LabelDecorator create(PrimitiveQueryUpdater manager, NodeContext context, LabelDecoratorKey key) {
		Object o = context.getConstant(BuiltinKeys.INPUT);
		if (o instanceof IProperty) {
			IProperty prop = (IProperty) o;
			if (o instanceof IArrayProperty) {
				IArrayProperty array = (IArrayProperty) o;
				if (array.isSlice())
					// Prevent the decorator from overworking on each and every sliced table row.
					return null;
			}

			final Resource[] data = prop.getData(Resource[].class);
			if (data == null)
				return null;
			if (data.length != 3)
				return null;

			return new PropertyReadOnlyLabelDecorator(manager, context, key);
		}
		return null;
	}

	static class PropertyReadOnlyLabelDecorator extends LabelDecoratorContributionImpl {

		public PropertyReadOnlyLabelDecorator(PrimitiveQueryUpdater manager, NodeContext context, LabelDecoratorKey key) {
			super(manager, context, key);
		}

		@Override
		public LabelDecorator getDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {
			IProperty prop = (IProperty) context.getConstant(BuiltinKeys.INPUT);
			final Resource[] data = prop.getData(Resource[].class);
			Layer0 L0 = Layer0.getInstance(graph);
			Object o = graph.getPossibleRelatedValue2(data[1], L0.readOnly, Bindings.BOOLEAN);
			if (!Boolean.TRUE.equals(o))
				return null;

			return new LabelDecorator.Stub() {
				@Override
				public <C> C decorateForeground(C color, String column, int itemIndex) {
					return null;
				}
				@SuppressWarnings("unchecked")
				@Override
				public <C> C decorateBackground(C color, String column, int itemIndex) {
					if (ColumnKeys.VALUE.equals(column))
						return (C) READONLY_GRAY;
					return null;
				}
			};
		}

	}

}
