/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

/**
 * @author Tuukka Lehtonen
 */
public class ModelledWizard extends Wizard implements ModelledAction {

	final Resource configuration;
	
	final private ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
	
	private Runnable finishAction;
	
    public ModelledWizard(Resource configuration) {
        setNeedsProgressMonitor(true);
        this.configuration = configuration;
    }

    @Override
    public void addPages() {
        super.addPages();
        for(IWizardPage page : pages) addPage(page);
    }

    @Override
    public boolean performFinish() {
        return true;
    }

	@Override
	public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {

		String title = Simantics.getSession().syncRequest(new Read<String>() {

			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource br = BrowsingResource.getInstance(graph);
				return graph.getPossibleRelatedValue(configuration, br.Wizard_Title, Bindings.STRING);
			}
			
		});
		
		setWindowTitle(title);
		
		List<Resource> pageResources = Simantics.getSession().syncRequest(new Read<List<Resource>>() {

			@Override
			public List<Resource> perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource br = BrowsingResource.getInstance(graph);
				Resource pageList = graph.getPossibleObject(configuration, br.Wizard_Pages);
				if(pageList == null) return Collections.emptyList();
				return OrderedSetUtils.toList(graph, pageList);
			}
			
		});

		for(final Resource page : pageResources) {

			ModelledWizardPage p = Simantics.getSession().syncRequest(new PossibleAdapter<ModelledWizardPage>(page, ModelledWizardPage.class));			
			pages.add(p.create(context, support));
			
		}
		
		ModelledAction finishAction = Simantics.getSession().syncRequest(new Read<ModelledAction>() {
			@Override
			public ModelledAction perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource BRO = BrowsingResource.getInstance(graph);
				Resource actionResource = graph.getPossibleObject(configuration, BRO.Wizard_FinishAction);
				return graph.adapt(actionResource, ModelledAction.class);
			}
		}); 
		
		this.finishAction = finishAction.create(null, null, support);
		
		return new Runnable() {

			@Override
			public void run() {
				
				WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), ModelledWizard.this);
			    dialog.create();
			    support.update();
			    dialog.open();	
			    
			    if(ModelledWizard.this.finishAction != null) ModelledWizard.this.finishAction.run();
			    
			}
			
		};
		
	}

}
