/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * The default JFace double click event handler for {@link GraphExplorer}.
 * 
 * <p>
 * Consults every IDoubleClickAction in DoubleClickExtensionManager for possible
 * actions for the selection resource. IDoubleClickActions can provide actions
 * with priorities, see {@link IPriorityAction}. The handler selects the action
 * with the highest priority and executes it. If there are multiple actions of
 * the highest used priority, a dialog will be opened so that the user can
 * choose the action to take.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see IPriorityAction
 */
public class DefaultMouseListener extends GraphExplorerMouseAdapter {

    public DefaultMouseListener(GraphExplorer ge) {
        super(ge);
    }

    @Override
    protected void handleContextDoubleClick(Control tree, ISelection selection) {
        // First see if node is an IDoubleClickableNode
        IDoubleClickableNode doubleClickable = AdaptionUtils.adaptToSingle(selection, IDoubleClickableNode.class);
        if (doubleClickable != null) {
            if (doubleClickable.handleDoubleClick())
                return;
        }

        // Try the doubleClick-extensions
        final String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
        Simantics.getSession().asyncRequest(new ChooseActionRequest(tree.getShell(), ge, selection, perspectiveId), new ProcedureAdapter<Object>() {
            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(ChooseActionRequest.class.getName() + " failed, see exception for details.", t);
            }
        });
    }

}
