/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.CheckedStateKey;

/**
 * A CheckState is used with check box trees (see SWT.CHECK). CheckStates are
 * created by {@link CheckedStateFactory}s.
 * 
 * @author Antti Villberg
 * 
 */
public interface CheckedStateFactory {

    /**
     * Returns a {@link CheckedState} for the specified input node context or
     * <code>null</code> if this factory is unable to provide a CheckedState for the
     * input.
     * 
     * @param updater the updater that needs to be invoked through
     *        {@link PrimitiveQueryUpdater#scheduleReplace(NodeContext, org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey, Object)}
     *        to invalidate the result CheckState of this method if when the
     *        state changes in any way.
     * @param context the input for which to create a {@link CheckedState}
     * @param key the key representing the primitive query that resulted in
     *        calling this {@link CheckedStateFactory}
     * @return a CheckedState that describes checkedness aspects of
     *         the specified input context or <code>null</code> if a state
     *         cannot be provided for any reason
     */
    CheckedState create(PrimitiveQueryUpdater updater, NodeContext context, CheckedStateKey key);

}
