/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.nattable.NatTableGraphExplorer;
import org.simantics.browsing.ui.nattable.TreeNode;

public class GEColumnAccessor
implements IColumnPropertyAccessor<TreeNode> {
    NatTableGraphExplorer ge;

    public GEColumnAccessor(NatTableGraphExplorer ge) {
        this.ge = ge;
    }

    public int getColumnCount() {
        return this.ge.getColumns().length;
    }

    public Object getDataValue(TreeNode rowObject, int columnIndex) {
        if (columnIndex > 0) {
            return rowObject.getValueString(columnIndex);
        }
        String val = "";
        int i = 0;
        while (i < rowObject.getDepth()) {
            val = String.valueOf(val) + "   ";
            ++i;
        }
        return String.valueOf(val) + rowObject.getValueString(columnIndex);
    }

    public void setDataValue(TreeNode rowObject, int columnIndex, Object newValue) {
        Labeler.Modifier modifier = this.ge.getModifier(rowObject, columnIndex);
        if (modifier == null) {
            throw new IllegalArgumentException("Items is not modifiable");
        }
        modifier.modify(newValue != null ? newValue.toString() : "");
    }

    public String getColumnProperty(int columnIndex) {
        return this.ge.getColumns()[columnIndex].getKey();
    }

    public int getColumnIndex(String propertyName) {
        Column[] columns = this.ge.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].getKey().equals(propertyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

