package org.simantics.browsing.ui.model.tests;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class HasInstanceOfTest implements Test {
    Resource type;

    public HasInstanceOfTest(Resource type) {
        this.type = type;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType == Resource.class;
    }

    @Override
    public boolean test(ReadGraph graph, Object content)
            throws DatabaseException {
        return graph.isInstanceOf((Resource)content, type);
    }
    
    
}
