/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.sorters;

import java.util.Map;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.strings.AlphanumComparator;

public class AlphanumericSorter extends AbstractSorter<String> {

    public static final AlphanumericSorter INSTANCE = new AlphanumericSorter();
    
    private AlphanumericSorter() {}
    
    @Override
    public String getSortingCriterion(ReadGraph graph, BrowseContext context,
            NodeContext node) throws DatabaseException {
        Map<String,String> labels = context.getLabel(graph, node);
        String label = labels.get(ColumnKeys.SINGLE);
        if(label == null)
            return labels.isEmpty() ? "" : labels.values().iterator().next();
        else
            return label;
    }

    @Override
    public int compare(String a, String b) {
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(a, b);
    }

}
